<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif: xslShowHelp" />
    <!-- Horizontal Alignment to ASCII Import Format -->
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads/GeometryProject">
					<xsl:text>**NazevBodu,Ys-jtsk,Xs-jtsk,Z,NazevPrvku,Popis</xsl:text>
                    <xsl:text/>
					<xsl:for-each select="GeometryPoint">		
                        <xsl:apply-templates/>
					</xsl:for-each>	                   
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
   	<xsl:template match="GeometryPointProperties">
			<xsl:value-of select="@PointName"/><xsl:text>,</xsl:text>
			<xsl:value-of select="cif:ordinateFormat(number(@easting)*(-1))"/><xsl:text>,</xsl:text>
			<xsl:value-of select="cif:ordinateFormat(number(@northing)*(-1))"/><xsl:text>,</xsl:text>
			<xsl:value-of select="cif:ordinateFormat(number(@elevation))"/><xsl:text>,</xsl:text>
			<xsl:variable name="fullFeatureName" select="@FeatureName" />
			<xsl:variable name="items">
			  <xsl:call-template name="splitStringToItems">
				<xsl:with-param name="list" select="$fullFeatureName" />
			  </xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="msxsl:node-set($items)/item[last()]"/><xsl:text>,</xsl:text>
			<xsl:value-of select="@PointDescription"/>
			<!-- <xsl:text>&#xd;</xsl:text> -->
	</xsl:template>
	<xsl:template name="splitStringToItems">
      <xsl:param name="list" />
      <xsl:variable name="delimiter" select="'\'">
      </xsl:variable>
      <xsl:variable name="newlist">
        <xsl:choose>
          <xsl:when test="contains($list, $delimiter)">
            <xsl:value-of select="normalize-space($list)" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(normalize-space($list), $delimiter)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="firstString" select="substring-before($newlist, $delimiter)" />
      <xsl:variable name="remainingString" select="substring-after($newlist, $delimiter)" />
      <item>
        <xsl:value-of select="$firstString" />
      </item>
      <xsl:if test="$remainingString">
        <xsl:call-template name="splitStringToItems">
          <xsl:with-param name="list" select="$remainingString" />
          <xsl:with-param name="delimiter" select="$delimiter" />
        </xsl:call-template>
      </xsl:if>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>    Musí být vybrán nejméně jeden směrový bod &#xd;</xsl:text>
        <xsl:text>    nebo body zadejte graficky.&#xd;</xsl:text>   
        <xsl:text>Copyright 2019 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
